define([
    'Layout',
    'modules/notifications/models/notifications-collection',
    'modules/notifications/notifications-button-view',
],
function(Layout, NotificationCollection, NotificationsButtonView) {
    'use strict';

    describe('Notifications Button View', function() {
        var view;
        var $view;
        var layout = new Layout();
        var collection;

        // TODO this should be in the beforeEach
        layout.render();


        beforeEach(function() {
            collection = new NotificationCollection();
            view = new NotificationsButtonView({collection: collection});

            layout.showChildView('content', view);
            $view = view.$el;
        });

        afterEach(function() {
            layout.getRegion('content').empty();
        });

        describe('when there are no unread notifications', function() {
            it('has no badge', function() {
                expect($view.find('.ui-btn .badge').length).toEqual(0);

                expect($view.find('.ui-btn').attr('aria-label')).toEqual('Notifications');
            });
        });

        describe('when there are unread notifications', function() {
            it('has a badge with the unread count', function() {
                collection.add(Array.apply(null, Array(5)).map(Object.prototype.valueOf, { readFlag: false }));
                view.render();

                expect($view.find('.ui-btn .badge').text()).toEqual('5');
                expect($view.find('.ui-btn').attr('aria-label')).toEqual('5 Unread Notifications');
            });

            it('when the unread count is greater than 99, formats the badge number', function() {
                collection.add(Array.apply(null, Array(100)).map(Object.prototype.valueOf, { readFlag: false }));
                view.render();

                expect($view.find('.ui-btn .badge').text()).toEqual('99+');
                expect($view.find('.ui-btn').attr('aria-label')).toEqual('99+ Unread Notifications');
            });
        });
    });
}
);
